<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright   2019 Lifestyle Webconsulting GmbH
 * @link        http://www.life-style.de
 */

declare(strict_types=1);

namespace LifeStyle\Sylius\PricingPlugin\ShopApi\Services\Helper;

use InvalidArgumentException;

/**
 * Class VersionInflector
 * @package LifeStyle\Sylius\PricingPlugin\ShopApi\Services\Helper
 */
class VersionInflector
{
    /**
     * @var int
     */
    private $version = 1;

    /**
     * @param int $version
     */
    public function setVersion(int $version): void
    {
        $this->version = $version;
    }

    /**
     * @return int
     */
    public function getVersion(): int
    {
        return $this->version;
    }

    /**
     * @return string
     */
    public function getVersionPrefix(): string
    {
        return 'Version' . $this->version;
    }

    /**
     * @param string $namespace
     * @param string $className
     * @return string
     */
    public function inflect(string $namespace, string $className)
    {
        $class = $namespace . '\\' . $this->getVersionPrefix() . '\\' . $className;

        if (preg_match('#\s#', $class)) {
            throw new InvalidArgumentException(sprintf(
                'A class name can not contain whitespaces! (Class name "%s")',
                $class
            ));
        }

        if (!class_exists($class)) {
            throw new InvalidArgumentException(sprintf(
                'Class not found! (Class name "%s")',
                $class
            ));
        }

        return $class;
    }
}
