<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright   2019 Lifestyle Webconsulting GmbH
 * @link        http://www.life-style.de
 */

declare(strict_types=1);

namespace LifeStyle\Sylius\PricingPlugin\ShopApi\Services\Product\ShowPrice\Request\Version1;

use Symfony\Component\Validator\Constraints as Assert;

/**
 * Class QueryParameters
 * @package LifeStyle\Sylius\PricingPlugin\ShopApi\Services\Product\ShowPrice\Request\Version1
 */
class QueryParameters
{
    /**
     * @Assert\NotBlank(message="The parameter 'channel' can not be emtpy.")
     * @var string
     */
    private $channel;

    /**
     * the product code
     * @Assert\NotBlank(message="The parameter 'code' can not be emtpy.")
     * @var string
     */
    private $code;

    /**
     * @Assert\NotBlank(message="The parameter 'quantity' can not be emtpy.")
     * @var integer|null
     */
    private $quantity;

    /**
     * @var string
     */
    private $userId;

    /**
     * QueryParameters constructor.
     * @param string $channel
     * @param string $code
     * @param int|null $quantity
     * @param string|null $userId
     */
    public function __construct(string $channel, string $code, ?int $quantity, ?string $userId)
    {
        $this->channel = $channel;
        $this->code = $code;
        $this->quantity = $quantity;
        $this->userId = $userId;
    }

    /**
     * @return string
     */
    public function getChannel(): string
    {
        return $this->channel;
    }

    /**
     * @return string
     */
    public function getCode(): string
    {
        return $this->code;
    }

    /**
     * @return int|null
     */
    public function getQuantity(): ?int
    {
        return $this->quantity;
    }

    /**
     * @return string
     */
    public function getUserId(): ?string
    {
        return $this->userId;
    }
}
