<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright   2019 Lifestyle Webconsulting GmbH
 * @link        http://www.life-style.de
 */

declare(strict_types=1);

namespace LifeStyle\Sylius\PricingPlugin\ShopApi\Services\Product\ShowPrice\Response\Version1;

/**
 * Class CalculatedPrices
 * @package LifeStyle\Sylius\PricingPlugin\ShopApi\Services\Product\ShowPrice\Response\Version1
 */
class CalculatedPrices
{
    /**
     * @var integer
     */
    private $quantity;

    /**
     * @var integer
     */
    private $unitPrice;

    /**
     * @var double|null
     */
    private $taxUnitAmount;

    /**
     * @var double
     */
    private $taxRateAmount;

    /**
     * @var double
     */
    private $taxRateAmountAsPercent;

    /**
     * @var boolean
     */
    private $taxIncludedInPrice;

    /**
     * @var integer
     */
    private $totalPrice;

    /**
     * @var integer
     */
    private $unmodifiedUnitPrice;

    /**
     * @var integer|null
     */
    private $unmodifiedOriginalUnitPrice;

    /**
     * @param int $quantity
     */
    public function setQuantity(int $quantity): void
    {
        $this->quantity = $quantity;
    }

    /**
     * @param int $unitPrice
     */
    public function setUnitPrice(int $unitPrice): void
    {
        $this->unitPrice = $unitPrice;
    }

    /**
     * @param float|null $taxUnitAmount
     */
    public function setTaxUnitAmount(?float $taxUnitAmount): void
    {
        $this->taxUnitAmount = $taxUnitAmount;
    }

    /**
     * @param float $taxRateAmount
     */
    public function setTaxRateAmount(float $taxRateAmount): void
    {
        $this->taxRateAmount = $taxRateAmount;
    }

    /**
     * @param float $taxRateAmountAsPercent
     */
    public function setTaxRateAmountAsPercent(float $taxRateAmountAsPercent): void
    {
        $this->taxRateAmountAsPercent = $taxRateAmountAsPercent;
    }

    /**
     * @param bool $taxIncludedInPrice
     */
    public function setTaxIncludedInPrice(bool $taxIncludedInPrice): void
    {
        $this->taxIncludedInPrice = $taxIncludedInPrice;
    }

    /**
     * @param int $totalPrice
     */
    public function setTotalPrice(int $totalPrice): void
    {
        $this->totalPrice = $totalPrice;
    }

    /**
     * @param int $unmodifiedUnitPrice
     */
    public function setUnmodifiedUnitPrice(int $unmodifiedUnitPrice): void
    {
        $this->unmodifiedUnitPrice = $unmodifiedUnitPrice;
    }

    /**
     * @param int|null $unmodifiedOriginalUnitPrice
     */
    public function setUnmodifiedOriginalUnitPrice(?int $unmodifiedOriginalUnitPrice): void
    {
        $this->unmodifiedOriginalUnitPrice = $unmodifiedOriginalUnitPrice;
    }
}
