<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright   2019 Lifestyle Webconsulting GmbH
 * @link        http://www.life-style.de
 */

declare(strict_types=1);

namespace LifeStyle\Sylius\PricingPlugin\ShopApi\Services\Product\ShowPrice\ResponseData;

use Sylius\Component\Core\Model\ProductVariantInterface;
use Sylius\Component\Core\Model\ChannelInterface;
use Sylius\Component\Core\Model\ShopUserInterface;

/**
 * Class CalculatedPriceData
 * @package LifeStyle\Sylius\PricingPlugin\ShopApi\Services\Product\ShowPrice\ResponseData
 */
class CalculatedPriceData
{
    /**
     * @var integer
     */
    private $quantity;

    /**
     * @var integer
     */
    private $unitPrice;

    /**
     * @var double|null
     */
    private $taxUnitAmount;

    /**
     * @var double
     */
    private $taxRateAmount;

    /**
     * @var double
     */
    private $taxRateAmountAsPercent;

    /**
     * @var boolean
     */
    private $taxIncludedInPrice;

    /**
     * @var integer
     */
    private $totalPrice;

    /**
     * @var integer
     */
    private $unmodifiedUnitPrice;

    /**
     * @var integer|null
     */
    private $unmodifiedOriginalUnitPrice;

    /**
     * @return int
     */
    public function getQuantity(): int
    {
        return $this->quantity;
    }

    /**
     * @param int $quantity
     */
    public function setQuantity(int $quantity): void
    {
        $this->quantity = $quantity;
    }

    /**
     * @return int
     */
    public function getUnitPrice(): int
    {
        return $this->unitPrice;
    }

    /**
     * @param int $unitPrice
     */
    public function setUnitPrice(int $unitPrice): void
    {
        $this->unitPrice = $unitPrice;
    }

    /**
     * @return float|null
     */
    public function getTaxUnitAmount(): ?float
    {
        return $this->taxUnitAmount;
    }

    /**
     * @param float|null $taxUnitAmount
     */
    public function setTaxUnitAmount(?float $taxUnitAmount): void
    {
        $this->taxUnitAmount = $taxUnitAmount;
    }

    /**
     * @return float
     */
    public function getTaxRateAmount(): float
    {
        return $this->taxRateAmount;
    }

    /**
     * @param float $taxRateAmount
     */
    public function setTaxRateAmount(float $taxRateAmount): void
    {
        $this->taxRateAmount = $taxRateAmount;
    }

    /**
     * @return float
     */
    public function getTaxRateAmountAsPercent(): float
    {
        return $this->taxRateAmountAsPercent;
    }

    /**
     * @param float $taxRateAmountAsPercent
     */
    public function setTaxRateAmountAsPercent(float $taxRateAmountAsPercent): void
    {
        $this->taxRateAmountAsPercent = $taxRateAmountAsPercent;
    }

    /**
     * @return bool
     */
    public function isTaxIncludedInPrice(): bool
    {
        return $this->taxIncludedInPrice;
    }

    /**
     * @param bool $taxIncludedInPrice
     */
    public function setTaxIncludedInPrice(bool $taxIncludedInPrice): void
    {
        $this->taxIncludedInPrice = $taxIncludedInPrice;
    }

    /**
     * @return int
     */
    public function getTotalPrice(): int
    {
        return $this->totalPrice;
    }

    /**
     * @param int $totalPrice
     */
    public function setTotalPrice(int $totalPrice): void
    {
        $this->totalPrice = $totalPrice;
    }

    /**
     * @return int
     */
    public function getUnmodifiedUnitPrice(): int
    {
        return $this->unmodifiedUnitPrice;
    }

    /**
     * @param int $unmodifiedUnitPrice
     */
    public function setUnmodifiedUnitPrice(int $unmodifiedUnitPrice): void
    {
        $this->unmodifiedUnitPrice = $unmodifiedUnitPrice;
    }

    /**
     * @return int|null
     */
    public function getUnmodifiedOriginalUnitPrice(): ?int
    {
        return $this->unmodifiedOriginalUnitPrice;
    }

    /**
     * @param int|null $unmodifiedOriginalUnitPrice
     */
    public function setUnmodifiedOriginalUnitPrice(?int $unmodifiedOriginalUnitPrice): void
    {
        $this->unmodifiedOriginalUnitPrice = $unmodifiedOriginalUnitPrice;
    }
}
