<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright   2019 Lifestyle Webconsulting GmbH
 * @link        http://www.life-style.de
 */

declare(strict_types=1);

namespace LifeStyle\Sylius\PricingPlugin\ShopApi\Services\Product\ShowPrice\ResponseData;

use Sylius\Component\Core\Model\ProductVariantInterface;
use Sylius\Component\Core\Model\ChannelInterface;
use Sylius\Component\Core\Model\ShopUserInterface;

/**
 * Class DiscountData
 * @package LifeStyle\Sylius\PricingPlugin\ShopApi\Services\Product\ShowPrice\ResponseData
 */
class CustomDiscountData
{
    /**
     * @var integer
     */
    private $priceListId;

    /**
     * @var integer
     */
    private $discount;

    /**
     * @var string
     */
    private $type;

    /**
     * @return int
     */
    public function getPriceListId(): int
    {
        return $this->priceListId;
    }

    /**
     * @param int $priceListId
     */
    public function setPriceListId(int $priceListId): void
    {
        $this->priceListId = $priceListId;
    }

    /**
     * @return int
     */
    public function getDiscount(): int
    {
        return $this->discount;
    }

    /**
     * @param int $discount
     */
    public function setDiscount(int $discount): void
    {
        $this->discount = $discount;
    }

    /**
     * @return string
     */
    public function getType(): string
    {
        return $this->type;
    }

    /**
     * @param string $type
     */
    public function setType(string $type): void
    {
        $this->type = $type;
    }
}
