<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright   2019 Lifestyle Webconsulting GmbH
 * @link        http://www.life-style.de
 */

declare(strict_types=1);

namespace LifeStyle\Sylius\PricingPlugin\ShopApi\Services\Product\ShowPrice\ResponseData;

use Doctrine\Common\Collections\ArrayCollection;
use LifeStyle\Sylius\PricingPlugin\ShopApi\Services\Product\ShowPrice\Response\Version1\CustomDiscount;

/**
 * Class ResponseData
 * @package LifeStyle\Sylius\PricingPlugin\ShopApi\Services\Product\ShowPrice\ResponseData
 */
class ResponseData
{
    /**
     * @var string
     */
    private $productVariantCode;

    /**
     * @var integer
     */
    private $productVariantId;

    /**
     * @var string|null
     */
    private $productCode;

    /**
     * @var integer
     */
    private $productId;

    /**
     * @var string|null
     */
    private $productName;

    /**
     * @var integer
     */
    private $unmodifiedPrice;

    /**
     * @var integer|null
     */
    private $unmodifiedOrigPrice;

    /**
     * @var ShopUserData
     */
    private $shopUserData;

    /**
     * @var ChannelData
     */
    private $channelData;

    /**
     * @var CalculatedPriceData
     */
    private $calculatedPriceData;

    /**
     * @var ArrayCollection|TierPriceData[]
     */
    private $tierPrices;

    /**
     * @var ArrayCollection|CustomDiscount[]
     */
    private $cutomDiscounts;

    /**
     * ResponseData constructor.
     */
    public function __construct()
    {
        $this->tierPrices = new ArrayCollection();
        $this->cutomDiscounts = new ArrayCollection();
    }

    /**
     * @return string
     */
    public function getProductVariantCode(): string
    {
        return $this->productVariantCode;
    }

    /**
     * @param string $productVariantCode
     */
    public function setProductVariantCode(string $productVariantCode): void
    {
        $this->productVariantCode = $productVariantCode;
    }

    /**
     * @return int
     */
    public function getProductVariantId(): int
    {
        return $this->productVariantId;
    }

    /**
     * @param int $productVariantId
     */
    public function setProductVariantId(int $productVariantId): void
    {
        $this->productVariantId = $productVariantId;
    }

    /**
     * @return string|null
     */
    public function getProductCode(): ?string
    {
        return $this->productCode;
    }

    /**
     * @param string|null $productCode
     */
    public function setProductCode(?string $productCode): void
    {
        $this->productCode = $productCode;
    }

    /**
     * @return int
     */
    public function getProductId(): int
    {
        return $this->productId;
    }

    /**
     * @param int $productId
     */
    public function setProductId(int $productId): void
    {
        $this->productId = $productId;
    }

    /**
     * @return string|null
     */
    public function getProductName(): ?string
    {
        return $this->productName;
    }

    /**
     * @param string|null $productName
     */
    public function setProductName(?string $productName): void
    {
        $this->productName = $productName;
    }

    /**
     * @return int
     */
    public function getUnmodifiedPrice(): int
    {
        return $this->unmodifiedPrice;
    }

    /**
     * @param int $unmodifiedPrice
     */
    public function setUnmodifiedPrice(int $unmodifiedPrice): void
    {
        $this->unmodifiedPrice = $unmodifiedPrice;
    }

    /**
     * @return int|null
     */
    public function getUnmodifiedOrigPrice(): ?int
    {
        return $this->unmodifiedOrigPrice;
    }

    /**
     * @param int|null $unmodifiedOrigPrice
     */
    public function setUnmodifiedOrigPrice(?int $unmodifiedOrigPrice): void
    {
        $this->unmodifiedOrigPrice = $unmodifiedOrigPrice;
    }

    /**
     * @return ShopUserData|null
     */
    public function getShopUserData(): ?ShopUserData
    {
        return $this->shopUserData;
    }

    /**
     * @param ShopUserData $shopUserData
     */
    public function setShopUserData(ShopUserData $shopUserData): void
    {
        $this->shopUserData = $shopUserData;
    }

    /**
     * @return ChannelData
     */
    public function getChannelData(): ChannelData
    {
        return $this->channelData;
    }

    /**
     * @param ChannelData $channelData
     */
    public function setChannelData(ChannelData $channelData): void
    {
        $this->channelData = $channelData;
    }

    /**
     * @return CalculatedPriceData
     */
    public function getCalculatedPriceData(): CalculatedPriceData
    {
        return $this->calculatedPriceData;
    }

    /**
     * @param CalculatedPriceData $calculatedPriceData
     */
    public function setCalculatedPriceData(CalculatedPriceData $calculatedPriceData): void
    {
        $this->calculatedPriceData = $calculatedPriceData;
    }

    /**
     * @return ArrayCollection|TierPriceData[]
     */
    public function getTierPrices()
    {
        return $this->tierPrices;
    }

    /**
     * @param TierPriceData $tierPrice
     */
    public function addTierPrice(TierPriceData $tierPrice): void
    {
        if (!$this->tierPrices->contains($tierPrice)) {
            $this->tierPrices->add($tierPrice);
        }
    }

    /**
     * @return ArrayCollection|CustomDiscount[]
     */
    public function getCutomDiscounts()
    {
        return $this->cutomDiscounts;
    }

    /**
     * @param CustomDiscountData $customDiscountData
     */
    public function addCustomDiscount(CustomDiscountData $customDiscountData): void
    {
        if (!$this->cutomDiscounts->contains($customDiscountData)) {
            $this->cutomDiscounts->add($customDiscountData);
        }
    }
}
