# Life-Style Sylius Pricing Plugin

Adds tier price function and price discounts to Sylius.

Also adds enable/disable function for product variants.

##Installation

The repositories are private. You have to add them to your projects `composer.json`. Make sure you have access to the repositories.

```yaml
{
  "name": "your-project",

  ...

  "repositories": [
    ...
    {
        "type": "git",
        "url": "ssh://git@stash.life-style.de:7999/lcp/lifestylesyliuspricingplugin.git"
    },
    {
      "type": "git",
      "url": "ssh://git@stash.life-style.de:7999/lcp/lifestylesyliusproductvariantplugin.git"
    }
  ]
}
```

Install the package.

```bash
composer require lifestyle/sylius-pricing-plugin
```

### Add to bundles

If you Sylius is based on Symfony 3.4 or 4.x this is done by `composer`.

_config/bundles.php:_
```php
<?php

return [
    ...
    Lifestyle\Sylius\ProductVariant\LifestyleSyliusProductVariantPlugin::class => ['all' => true],
    LifeStyle\Sylius\PricingPlugin\LifeStyleSyliusPricingPlugin::class => ['all' => true],
];
```

### Add route

_config/routes/lifestyle_sylius_pricing_plugin.yaml:_

```yaml
ls_bundle:
  resource: '@LifeStyleSyliusPricingPlugin/Resources/config/routing.yml'
```

### Update database

```bash
cp vendor/lifestyle/sylius-pricing-plugin/src/Migrations/Version*.php src/Migrations/.
php bin/console doctrine:migrations:migrate
```

### Update twig configuration

To load admin-templates the twig configuration in your project has to be updated like:

config/packages/twig.yaml
```yaml
twig:
    paths:
        '%kernel.project_dir%/templates': ~
        '%kernel.project_dir%/themes': ~
        '%kernel.project_dir%/vendor/lifestyle/sylius-pricing-plugin/src/Resources/views/Admin': 'SyliusAdmin'
    debug: '%kernel.debug%'
    strict_variables: '%kernel.debug%'
```

## Configuration

_config/packages/lifestyle.yaml:_
```yaml
imports:
    - { resource: "@LifestyleSyliusProductVariantPlugin/Resources/config/config.yml" }
    - { resource: "@LifeStyleSyliusPricingPlugin/Resources/config/config.yml" }
```

good luck and have fun!
