<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright   2019 Lifestyle Webconsulting GmbH
 * @link        http://www.life-style.de
 */

declare(strict_types=1);

namespace LifeStyle\Sylius\PricingPlugin\ShopApi\Services\Product\ShowPrice\Response\Version1;

use JMS\Serializer\Annotation as Serializer;
use LifeStyle\Sylius\PricingPlugin\ShopApi\Services\ResponseInterface;

/**
 * Class ShopUser
 * @package LifeStyle\Sylius\PricingPlugin\ShopApi\Services\Product\ShowPrice\Response\Version1
 */
class ShopUser
{
    /**
     * @var integer|null
     */
    private $userId;

    /**
     * @var integer|null
     */
    private $customerId;

    /**
     * @var string|null
     */
    private $userName;

    /**
     * @var integer|null
     */
    private $groupId;

    /**
     * @var string|null
     */
    private $groupName;

    /**
     * @var integer|null
     */
    private $priceListId;

    /**
     * @var string|null
     */
    private $priceListName;

    /**
     * @var boolean|null
     */
    private $priceListEnabled;

    /**
     * @param int|null $userId
     */
    public function setUserId(?int $userId): void
    {
        $this->userId = $userId;
    }

    /**
     * @param int|null $customerId
     */
    public function setCustomerId(?int $customerId): void
    {
        $this->customerId = $customerId;
    }

    /**
     * @param string|null $userName
     */
    public function setUserName(?string $userName): void
    {
        $this->userName = $userName;
    }

    /**
     * @param int|null $groupId
     */
    public function setGroupId(?int $groupId): void
    {
        $this->groupId = $groupId;
    }

    /**
     * @param string|null $groupName
     */
    public function setGroupName(?string $groupName): void
    {
        $this->groupName = $groupName;
    }

    /**
     * @param int|null $priceListId
     */
    public function setPriceListId(?int $priceListId): void
    {
        $this->priceListId = $priceListId;
    }

    /**
     * @param string|null $priceListName
     */
    public function setPriceListName(?string $priceListName): void
    {
        $this->priceListName = $priceListName;
    }

    /**
     * @param bool|null $priceListEnabled
     */
    public function setPriceListEnabled(?bool $priceListEnabled): void
    {
        $this->priceListEnabled = $priceListEnabled;
    }
}