<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright   2019 Lifestyle Webconsulting GmbH
 * @link        http://www.life-style.de
 */

declare(strict_types=1);

namespace LifeStyle\Sylius\PricingPlugin\ShopApi\Controller\Product;

use FOS\RestBundle\Controller\FOSRestController;
use FOS\RestBundle\Controller\Annotations as Rest;
use Symfony\Component\HttpFoundation\Request;
use LifeStyle\Sylius\PricingPlugin\ShopApi\Services\Product\ShowPrice\Handler;
use Symfony\Component\HttpFoundation\Response;

/**
 * Class ShowProductPriceDetailsByCodeAction
 * @package LifeStyle\Sylius\PricingPlugin\ShopApi\Controller\Product
 */
class PriceController extends FOSRestController
{

    /**
     * @Rest\Route("/{code}/{channel}")
     *
     * @param Request $request
     *
     * @return Response
     *
     * @throws \Exception
     */
    public function getPriceAction(Request $request)
    {
        /**
         * @var Handler $handler
         */
        $handler = $this->get(Handler::class);
        return $this->handleView($this->view()->setData($handler->handle($request)));
    }
}
