<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright   2019 Lifestyle Webconsulting GmbH
 * @link        http://www.life-style.de
 */

declare(strict_types=1);

namespace LifeStyle\Sylius\PricingPlugin\ShopApi\Services\Product\ShowPrice\Repository;

use Sylius\Component\Channel\Repository\ChannelRepositoryInterface;
use Sylius\Component\Product\Repository\ProductRepositoryInterface;
use Sylius\Component\Product\Repository\ProductVariantRepositoryInterface;
use Sylius\Component\Taxation\Calculator\CalculatorInterface;
use Sylius\Component\Taxation\Resolver\TaxRateResolverInterface;
use Sylius\Component\User\Repository\UserRepositoryInterface;
use LifeStyle\Sylius\PricingPlugin\Services\CustomDiscountFinderInterface;
use LifeStyle\Sylius\PricingPlugin\Services\TierPriceFinderInterface;

/**
 * Class CommonRepository
 * @package LifeStyle\Sylius\PricingPlugin\ShopApi\Services\Product\ShowPrice\Repository
 */
class CommonRepository
{
    /**
     * @var ChannelRepositoryInterface
     */
    private $channelRespository;

    /**
     * @var ProductRepositoryInterface
     */
    private $productRespository;

    /**
     * @var ProductVariantRepositoryInterface
     */
    private $productVariantRepository;

    /**
     * @var UserRepositoryInterface
     */
    private $userRepository;

    /**
     * @var TaxRateResolverInterface
     */
    private $taxRateResolver;

    /**
     * @var CalculatorInterface
     */
    private $taxCalculator;

    /**
     * @var CustomDiscountFinderInterface
     */
    private $customDiscountFinder;

    /**
     * @var TierPriceFinderInterface
     */
    private $tierPriceFinder;

    /**
     * CommonRepository constructor.
     * @param ChannelRepositoryInterface $channelRespository
     * @param ProductRepositoryInterface $productRespository
     * @param ProductVariantRepositoryInterface $productVariantRepository
     * @param UserRepositoryInterface $userRepository
     * @param TaxRateResolverInterface $taxRateResolver
     * @param CalculatorInterface $taxCalculator
     * @param CustomDiscountFinderInterface $customDiscountFinder
     * @param TierPriceFinderInterface $tierPriceFinder
     */
    public function __construct(
        ChannelRepositoryInterface $channelRespository,
        ProductRepositoryInterface $productRespository,
        ProductVariantRepositoryInterface $productVariantRepository,
        UserRepositoryInterface $userRepository,
        TaxRateResolverInterface $taxRateResolver,
        CalculatorInterface $taxCalculator,
        CustomDiscountFinderInterface $customDiscountFinder,
        TierPriceFinderInterface $tierPriceFinder
    ) {
        $this->channelRespository = $channelRespository;
        $this->productRespository = $productRespository;
        $this->productVariantRepository = $productVariantRepository;
        $this->userRepository = $userRepository;
        $this->taxRateResolver = $taxRateResolver;
        $this->taxCalculator = $taxCalculator;
        $this->customDiscountFinder = $customDiscountFinder;
        $this->tierPriceFinder = $tierPriceFinder;
    }

    /**
     * @return ChannelRepositoryInterface
     */
    public function getChannelRespository(): ChannelRepositoryInterface
    {
        return $this->channelRespository;
    }

    /**
     * @return ProductRepositoryInterface
     */
    public function getProductRespository(): ProductRepositoryInterface
    {
        return $this->productRespository;
    }

    /**
     * @return ProductVariantRepositoryInterface
     */
    public function getProductVariantRepository(): ProductVariantRepositoryInterface
    {
        return $this->productVariantRepository;
    }

    /**
     * @return UserRepositoryInterface
     */
    public function getUserRepository(): UserRepositoryInterface
    {
        return $this->userRepository;
    }

    /**
     * @return TaxRateResolverInterface
     */
    public function getTaxRateResolver(): TaxRateResolverInterface
    {
        return $this->taxRateResolver;
    }

    /**
     * @return CalculatorInterface
     */
    public function getTaxCalculator(): CalculatorInterface
    {
        return $this->taxCalculator;
    }

    /**
     * @return CustomDiscountFinderInterface
     */
    public function getCustomDiscountFinder(): CustomDiscountFinderInterface
    {
        return $this->customDiscountFinder;
    }

    /**
     * @return TierPriceFinderInterface
     */
    public function getTierPriceFinder(): TierPriceFinderInterface
    {
        return $this->tierPriceFinder;
    }
}
