<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright   2019 Lifestyle Webconsulting GmbH
 * @link        http://www.life-style.de
 */

declare(strict_types=1);

namespace LifeStyle\Sylius\PricingPlugin\Traits;

use LifeStyle\Sylius\DataModelPlugin\Entity\CustomDiscount;
use Sylius\Component\Core\Model\ChannelInterface;

/**
 * Interface TierPriceableInterface
 * @package LifeStyle\Sylius\PricingPlugin\Traits
 */
interface CustomDiscountableInterface
{
    /**
     * @param ChannelInterface $channel
     * @return CustomDiscount[]
     */
    public function getTierPricesForChannel(ChannelInterface $channel): array;

    /**
     * @return CustomDiscount[]
     */
    public function getCustomDiscounts(): array;

    /**
     * @param CustomDiscount[] $customDiscounts
     */
    public function setCustomDiscounts(array $customDiscounts): void;

    /**
     * @param ChannelInterface $channel
     * @param int|null $priceListId
     * @return array
     */
    public function getCustomDiscountsForChannelAndPriceList(ChannelInterface $channel, int $priceListId = null): array;
}
