<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright   2019 Lifestyle Webconsulting GmbH
 * @link        http://www.life-style.de
 */

declare(strict_types=1);

namespace LifeStyle\Sylius\PricingPlugin\ShopApi\Services\Product\ShowPrice\Request;

use LifeStyle\Sylius\PricingPlugin\ShopApi\Services\Helper\VersionInflector;
use LifeStyle\Sylius\PricingPlugin\ShopApi\Services\Product\ShowPrice\RequestParserInterface;
use Symfony\Component\Validator\Validator\ValidatorInterface;

/**
 * Class RequestParserFactory
 * @package LifeStyle\Sylius\PricingPlugin\ShopApi\Services\Product\ShowPrice\Request
 */
class RequestParserFactory
{
    /**
     * @var VersionInflector
     */
    private $versionInflector;

    /**
     * @var ValidatorInterface
     */
    private $validator;

    /**
     * RequestParserFactory constructor.
     * @param VersionInflector $versionInflector
     * @param ValidatorInterface $validator
     */
    public function __construct(
        VersionInflector $versionInflector,
        ValidatorInterface $validator
    ) {
        $this->versionInflector = $versionInflector;
        $this->validator = $validator;
    }

    /**
     * @return RequestParserInterface
     * @throws \Exception
     */
    public function createRequestParser(): RequestParserInterface
    {
        $className = $this->versionInflector->inflect(__NAMESPACE__, 'RequestParser');
        return new $className( $this->validator);
    }
}
