<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright   2019 Lifestyle Webconsulting GmbH
 * @link        http://www.life-style.de
 */

declare(strict_types=1);

namespace LifeStyle\Sylius\PricingPlugin\ShopApi\Services\Product\ShowPrice\Response;

use LifeStyle\Sylius\PricingPlugin\EventListener\PerformanceListener;
use LifeStyle\Sylius\PricingPlugin\ShopApi\Services\Helper\VersionInflector;
use LifeStyle\Sylius\PricingPlugin\ShopApi\Services\Product\ShowPrice\ResponseBuilderInterface;

/**
 * Class ResponeBuilderFactory
 * @package LifeStyle\Sylius\PricingPlugin\ShopApi\Services\Product\ShowPrice\Response
 */
class ResponeBuilderFactory
{
    /**
     * @var VersionInflector
     */
    private $versionInflector;

    /**
     * @var PerformanceListener
     */
    private $performance;

    /**
     * ResponeBuilderFactory constructor.
     * @param VersionInflector $versionInflector
     * @param PerformanceListener $performance
     */
    public function __construct(VersionInflector $versionInflector, PerformanceListener $performance)
    {
        $this->versionInflector = $versionInflector;
        $this->performance = $performance;
    }

    /**
     * @return ResponseBuilderInterface
     * @throws \Exception
     */
    public function createResponseBuilder(): ResponseBuilderInterface
    {
        $className = $this->versionInflector->inflect(__NAMESPACE__, 'ResponseBuilder');
        return new $className($this->performance);
    }
}
