<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright   2019 Lifestyle Webconsulting GmbH
 * @link        http://www.life-style.de
 */

declare(strict_types=1);

namespace LifeStyle\Sylius\PricingPlugin\ShopApi\Services\Product\ShowPrice\Response\Version1;

use LifeStyle\Sylius\PricingPlugin\EventListener\PerformanceListener;
use LifeStyle\Sylius\PricingPlugin\ShopApi\Services\Product\ShowPrice\ResponseBuilderInterface;
use LifeStyle\Sylius\PricingPlugin\ShopApi\Services\Product\ShowPrice\ResponseData\ResponseData;
use LifeStyle\Sylius\PricingPlugin\ShopApi\Services\ResponseInterface;

/**
 * Class ResponseBuilder
 * @package LifeStyle\Sylius\PricingPlugin\ShopApi\Services\Product\ShowPrice\Response\Version1
 */
class ResponseBuilder implements ResponseBuilderInterface
{
    /**
     * @var ResponseFactory
     */
    private $responseFactory;

    /**
     * @var PerformanceListener
     */
    private $performance;

    /**
     * ResponseBuilder constructor.
     *
     * @param PerformanceListener $performance
     */
    public function __construct(PerformanceListener $performance)
    {
        $this->performance = $performance;
        $this->responseFactory = new ResponseFactory();
    }

    /**
     * @param ResponseData $responseData
     * @return ResponseInterface
     */
    public function buildResponse(ResponseData $responseData): ResponseInterface
    {

        $response = $this->responseFactory->response();

        $response->setProductVariantCode($responseData->getProductVariantCode());
        $response->setProductVariantId($responseData->getProductVariantId());
        $response->setProductCode($responseData->getProductCode());
        $response->setProductId($responseData->getProductId());
        $response->setProductName($responseData->getProductName());

        //add shop user data
        if(null !== $responseData->getShopUserData()){
            $shopUser = $this->responseFactory->shopUser();
            $shopUser->setUserId($responseData->getShopUserData()->getUserId());
            $shopUser->setUserId($responseData->getShopUserData()->getUserId());
            $shopUser->setCustomerId($responseData->getShopUserData()->getCustomerId());
            $shopUser->setUserName($responseData->getShopUserData()->getUserName());

            $shopUser->setGroupId($responseData->getShopUserData()->getGroupId());
            $shopUser->setGroupName($responseData->getShopUserData()->getGroupName());
            $shopUser->setPriceListId($responseData->getShopUserData()->getPriceListId());
            $shopUser->setPriceListName($responseData->getShopUserData()->getPriceListName());
            $shopUser->setPriceListEnabled($responseData->getShopUserData()->getPriceListEnabled());

            $response->setShopUser($shopUser);
        }

        //add channel
        $channel =  $this->responseFactory->channel();
        $channel->setChannelId($responseData->getChannelData()->getChannelId());
        $channel->setChannelName($responseData->getChannelData()->getChannelName());
        $channel->setChannelCode($responseData->getChannelData()->getChannelCode());

        $response->setChannel($channel);

        //add calculated prices
        $calculatedPrices =  $this->responseFactory->calculatedPrices();
        $calculatedPrices->setQuantity($responseData->getCalculatedPriceData()->getQuantity());
        $calculatedPrices->setUnitPrice($responseData->getCalculatedPriceData()->getUnitPrice());
        $calculatedPrices->setTaxUnitAmount($responseData->getCalculatedPriceData()->getTaxUnitAmount());
        $calculatedPrices->setTaxRateAmount($responseData->getCalculatedPriceData()->getTaxRateAmount());
        $calculatedPrices->setTaxRateAmountAsPercent($responseData->getCalculatedPriceData()->getTaxRateAmountAsPercent());
        $calculatedPrices->setTaxIncludedInPrice($responseData->getCalculatedPriceData()->isTaxIncludedInPrice());
        $calculatedPrices->setTotalPrice($responseData->getCalculatedPriceData()->getTotalPrice());
        $calculatedPrices->setUnmodifiedUnitPrice($responseData->getCalculatedPriceData()->getUnmodifiedUnitPrice());
        $calculatedPrices->setUnmodifiedOriginalUnitPrice($responseData->getCalculatedPriceData()->getUnmodifiedOriginalUnitPrice());

        $response->setCalculatedPrices($calculatedPrices);

        //add tier prices
        foreach ($responseData->getTierPrices() as $tierPrice){
            $mappedTierPrice = $this->responseFactory->tierPrice();
            $mappedTierPrice->setQuantity($tierPrice->getQuantity());
            $mappedTierPrice->setPrice($tierPrice->getPrice());
            $mappedTierPrice->setPriceListId($tierPrice->getPriceListId());

            $response->addTierPrice($mappedTierPrice);
        }

        //add custom discounts
        foreach ($responseData->getCutomDiscounts() as $customDiscount){
            $mappedCutomDiscount = $this->responseFactory->customDiscount();
            $mappedCutomDiscount->setDiscount($customDiscount->getDiscount());
            $mappedCutomDiscount->setPriceListId($customDiscount->getPriceListId());

            $response->addCustomDiscount($mappedCutomDiscount);
        }

        //add script time
        $response->setScriptTimeSec($this->performance->getScriptSeconds());

        return $response;
    }
}
