<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright   2019 Lifestyle Webconsulting GmbH
 * @link        http://www.life-style.de
 */

declare(strict_types=1);

namespace LifeStyle\Sylius\PricingPlugin\ShopApi\Services\Product\ShowPrice\ResponseData;

use Sylius\Component\Core\Model\ProductVariantInterface;
use Sylius\Component\Core\Model\ChannelInterface;
use Sylius\Component\Core\Model\ShopUserInterface;

/**
 * Class TierPriceData
 * @package LifeStyle\Sylius\PricingPlugin\ShopApi\Services\Product\ShowPrice\ResponseData
 */
class TierPriceData
{
    /**
     * @var integer
     */
    private $quantity;

    /**
     * @var integer
     */
    private $price;

    /**
     * @var integer
     */
    private $priceListId;

    /**
     * @return int
     */
    public function getQuantity(): int
    {
        return $this->quantity;
    }

    /**
     * @param int $quantity
     */
    public function setQuantity(int $quantity): void
    {
        $this->quantity = $quantity;
    }

    /**
     * @return int
     */
    public function getPrice(): int
    {
        return $this->price;
    }

    /**
     * @param int $price
     */
    public function setPrice(int $price): void
    {
        $this->price = $price;
    }

    /**
     * @return int
     */
    public function getPriceListId(): int
    {
        return $this->priceListId;
    }

    /**
     * @param int $priceListId
     */
    public function setPriceListId(int $priceListId): void
    {
        $this->priceListId = $priceListId;
    }
}
