<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright   2019 Lifestyle Webconsulting GmbH
 * @link        http://www.life-style.de
 */

declare(strict_types=1);

namespace LifeStyle\Sylius\PricingPlugin\Factory;

use LifeStyle\Sylius\DataModelPlugin\Entity\CustomDiscountInterface;
use LifeStyle\Sylius\DataModelPlugin\Entity\ProductVariantInterface;
use Sylius\Bundle\CoreBundle\Fixture\Factory\ExampleFactoryInterface;

interface CustomDiscountsFactoryInterface extends ExampleFactoryInterface
{
    /**
     * Creates a tier price and attaches it to the product variant.
     *
     * @param ProductVariantInterface $productVariant
     * @param array                   $options
     *
     * @return CustomDiscountInterface
     */
    public function createAtProductVariant(
        ProductVariantInterface $productVariant,
        array $options = []
    ): CustomDiscountInterface;
}
