<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright   2019 Lifestyle Webconsulting GmbH
 * @link        http://www.life-style.de
 */

declare(strict_types=1);

namespace LifeStyle\Sylius\PricingPlugin\Repository;

use LifeStyle\Sylius\PricingPlugin\Traits\TierPriceableInterface;
use Sylius\Bundle\ResourceBundle\Doctrine\ORM\EntityRepository;
use Sylius\Component\Core\Model\ChannelInterface;

/**
 * Class TierPriceRepository
 * @package LifeStyle\Sylius\PricingPlugin\Repository
 */
class TierPriceRepository extends EntityRepository implements TierPriceRepositoryInterface
{
    /**
     * @param TierPriceableInterface $productVariant
     * @param ChannelInterface $channel
     * @return array
     */
    public function getSortedTierPrices(TierPriceableInterface $productVariant, ChannelInterface $channel): array
    {
        return $this->findBy(['productVariant' => $productVariant, 'channel' => $channel], ['qty' => 'ASC']);
    }
}
