<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright   2019 Lifestyle Webconsulting GmbH
 * @link        http://www.life-style.de
 */

declare(strict_types=1);

namespace LifeStyle\Sylius\PricingPlugin\ShopApi\Services\Product\ShowPrice\RequestData;

class RequestData
{
    /**
     * @var string
     */
    private $channel;

    /**
     * the product code
     * @var string
     */
    private $code;

    /**
     * @var int
     */
    private $quantity;

    /**
     * @var string|null
     */
    private $userId;

    /**
     * RequestData constructor.
     * @param string $channel
     * @param string $code
     * @param int $quantity
     * @param string|null $userId
     */
    public function __construct(string $channel, string $code, int $quantity, ?string $userId)
    {
        $this->channel = $channel;
        $this->code = $code;
        $this->quantity = $quantity;
        $this->userId = $userId;
    }

    /**
     * @return string
     */
    public function getChannel(): string
    {
        return $this->channel;
    }

    /**
     * @return string
     */
    public function getCode(): string
    {
        return $this->code;
    }

    /**
     * @return int|null
     */
    public function getQuantity(): ?int
    {
        return $this->quantity;
    }

    /**
     * @return string|null
     */
    public function getUserId(): ?string
    {
        return $this->userId;
    }
}
