<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright   2019 Lifestyle Webconsulting GmbH
 * @link        http://www.life-style.de
 */

declare(strict_types=1);

namespace LifeStyle\Sylius\PricingPlugin\ShopApi\Services\Product\ShowPrice\ResponseData;

use Sylius\Component\Core\Model\ProductVariantInterface;
use Sylius\Component\Core\Model\ChannelInterface;
use Sylius\Component\Core\Model\ShopUserInterface;

/**
 * Class ShopUserData
 * @package LifeStyle\Sylius\PricingPlugin\ShopApi\Services\Product\ShowPrice\ResponseData
 */
class ShopUserData
{
    /**
     * @var integer|null
     */
    private $userId;

    /**
     * @var integer|null
     */
    private $customerId;

    /**
     * @var string|null
     */
    private $userName;

    /**
     * @var integer|null
     */
    private $groupId;

    /**
     * @var string|null
     */
    private $groupName;

    /**
     * @var integer|null
     */
    private $priceListId;

    /**
     * @var string|null
     */
    private $priceListName;

    /**
     * @var boolean|null
     */
    private $priceListEnabled;

    /**
     * @return int|null
     */
    public function getUserId(): ?int
    {
        return $this->userId;
    }

    /**
     * @param int|null $userId
     */
    public function setUserId(?int $userId): void
    {
        $this->userId = $userId;
    }

    /**
     * @return int|null
     */
    public function getCustomerId(): ?int
    {
        return $this->customerId;
    }

    /**
     * @param int|null $customerId
     */
    public function setCustomerId(?int $customerId): void
    {
        $this->customerId = $customerId;
    }

    /**
     * @return string|null
     */
    public function getUserName(): ?string
    {
        return $this->userName;
    }

    /**
     * @param string|null $userName
     */
    public function setUserName(?string $userName): void
    {
        $this->userName = $userName;
    }

    /**
     * @return int|null
     */
    public function getGroupId(): ?int
    {
        return $this->groupId;
    }

    /**
     * @param int|null $groupId
     */
    public function setGroupId(?int $groupId): void
    {
        $this->groupId = $groupId;
    }

    /**
     * @return string|null
     */
    public function getGroupName(): ?string
    {
        return $this->groupName;
    }

    /**
     * @param string|null $groupName
     */
    public function setGroupName(?string $groupName): void
    {
        $this->groupName = $groupName;
    }

    /**
     * @return int|null
     */
    public function getPriceListId(): ?int
    {
        return $this->priceListId;
    }

    /**
     * @param int|null $priceListId
     */
    public function setPriceListId(?int $priceListId): void
    {
        $this->priceListId = $priceListId;
    }

    /**
     * @return string|null
     */
    public function getPriceListName(): ?string
    {
        return $this->priceListName;
    }

    /**
     * @param string|null $priceListName
     */
    public function setPriceListName(?string $priceListName): void
    {
        $this->priceListName = $priceListName;
    }

    /**
     * @return bool|null
     */
    public function getPriceListEnabled(): ?bool
    {
        return $this->priceListEnabled;
    }

    /**
     * @param bool|null $priceListEnabled
     */
    public function setPriceListEnabled(?bool $priceListEnabled): void
    {
        $this->priceListEnabled = $priceListEnabled;
    }
}
