<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2019 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Lifestyle\Sylius\Product\DependencyInjection;

use Symfony\Component\Config\Definition\Builder\TreeBuilder;
use Symfony\Component\Config\Definition\ConfigurationInterface;

/**
 * Class Configuration
 *
 * @copyright  2019 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 * @package Lifestyle\Sylius\Product\DependencyInjection
 */
class Configuration implements ConfigurationInterface
{
    /**
     * Generates the configuration tree builder.
     *
     * @return TreeBuilder The tree builder
     */
    public function getConfigTreeBuilder()
    {
        $treeBuilder = new TreeBuilder();
        $treeBuilder
            ->root('lifestyle_sylius_product')
                ->children()
                    ->arrayNode('assets')
                        ->isRequired()
                        ->children()
                            ->arrayNode('responsible_events')
                                ->children()
                                    ->arrayNode('publish')
                                        ->scalarPrototype()->end()
                                    ->end()
                                    ->arrayNode('unpublish')
                                        ->scalarPrototype()->end()
                                    ->end()
                                ->end()
                            ->end()
                            ->scalarNode('package_name')
                                ->example('pimcore')
                                ->info('Set to package name of the external images asset configuration: framework.assets.packages.PACKAGE_NAME.')
                                ->isRequired()
                            ->end()
                        ->end()
                    ->end()
                    ->arrayNode('products')
                        ->isRequired()
                        ->children()
                            ->arrayNode('responsible_events')
                                ->children()
                                    ->arrayNode('publish')
                                        ->scalarPrototype()->end()
                                    ->end()
                                    ->arrayNode('unpublish')
                                        ->scalarPrototype()->end()
                                    ->end()
                                ->end()
                            ->end()
                            ->scalarNode('on_hand_property')
                                ->example('onHand')
                                ->info('The pimcore product class property for number of items in stock. On-Hand - products that are in stock.')
                                ->isRequired()
                            ->end()
                        ->end()
                    ->end()
                    ->arrayNode('taxon')
                        ->children()
                            ->arrayNode('responsible_events')
                                ->children()
                                    ->arrayNode('publish')
                                        ->scalarPrototype()->end()
                                    ->end()
                                    ->arrayNode('unpublish')
                                        ->scalarPrototype()->end()
                                    ->end()
                                ->end()
                            ->end()
                        ->end()
                    ->end()
                ->end()
            ->end()
        ;

        return $treeBuilder;
    }
}
