<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2019 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Lifestyle\Sylius\Product\Request\Model\ProductPublish;

use Symfony\Component\Validator\Constraints as Assert;

/**
 * Class LocalizedFields
 *
 * @copyright  2019 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 * @package Lifestyle\Sylius\Product\Request\Model\ProductPublish
 */
class LocalizedFields
{
    /**
     * @var string
     */
    private $locale;

    /**
     * @Assert\NotNull(groups={"product", "variant"})
     * @var string|null
     */
    private $name;

    /**
     * @Assert\Regex(pattern="~^[^/]++~", groups={"product"})
     * @Assert\NotNull(groups={"product"})
     * @var string|null
     */
    private $slug;

    /**
     * @return string
     */
    public function getLocale(): string
    {
        return $this->locale;
    }

    /**
     * @param string $locale
     */
    public function setLocale(string $locale): void
    {
        $this->locale = $locale;
    }

    /**
     * @param string|null $name
     */
    public function setName(?string $name): void
    {
        $this->name = $name;
    }

    /**
     * @param string|null $slug
     */
    public function setSlug(?string $slug): void
    {
        $this->slug = $slug;
    }
}
