<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2019 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

declare(strict_types=1);

namespace Lifestyle\Sylius\Product\Entity;

use Sylius\Component\Core\Model\ProductImageInterface as BaseProductImageInterface;

/**
 * Interface ProductImageInterface
 *
 * @copyright  2019 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 * @package Lifestyle\Sylius\Product\Entity
 */
interface ProductImageInterface extends BaseProductImageInterface
{
    /**
     * @return string
     */
    public function getResourceId(): string;

    /**
     * @param string $resourceId
     */
    public function setResourceId(string $resourceId): void;
}
