<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2019 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Lifestyle\Sylius\Product\Request\Model\ProductPublish;

use Symfony\Component\Validator\Constraints as Assert;

/**
 * Class Option
 *
 * @copyright  2019 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 * @package Lifestyle\Sylius\Product\Request\Model\ProductPublish
 */
class Option
{
    /**
     * @Assert\NotNull(groups={"product", "variant"})
     * @Assert\Regex(
     *     pattern="/[a-zA-Z_\-]/",
     *     match=false,
     *     message="Option name should only contain letters, numbers, dashes and underscores.",
     *     groups={"product", "variant"}
     * )
     * @var string
     */
    private $name;

    /**
     * @param string $name
     */
    public function setName(?string $name): void
    {
        $this->name = $name;
    }
}
