<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2019 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Lifestyle\Sylius\Product\MessageHandler;

use Lifestyle\DataCollector\DataCollectorInterface;
use Lifestyle\RabbitMq\Consumer\Handler\HandlerInterface;
use Lifestyle\Sylius\Product\ProductHelper\ProductImageHelper;

/**
 * Class AssetUnpublishHandler
 *
 * @copyright  2019 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 * @package Lifestyle\Sylius\Product\MessageHandler
 */
class AssetUnpublishHandler implements HandlerInterface
{
    use MessageResponsibilityTrait;

    /**
     * @var ProductImageHelper
     */
    private $productImageHelper;

    /**
     * AssetPublishHandler constructor.
     * @param ProductImageHelper $productImageHelper
     */
    public function __construct(ProductImageHelper $productImageHelper)
    {
        $this->productImageHelper = $productImageHelper;
    }

    /**
     * Remove image
     *
     * @param DataCollectorInterface $dataCollector
     * @return bool Should return true, if data has been processed
     * @throws \Doctrine\ORM\ORMException
     */
    public function handle(DataCollectorInterface $dataCollector): bool
    {
        if (!$this->isResponsible($dataCollector)) {
            return false;
        }

        $resourceId = (int)$dataCollector->getItemValue('id');
        $this->productImageHelper->deleteImage($resourceId);

        return true;
    }
}
