<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2019 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Lifestyle\Sylius\Product\MessageHandler;

use Lifestyle\DataCollector\DataCollectorInterface;
use Lifestyle\RabbitMq\Consumer\Handler\HandlerInterface;
use Lifestyle\Sylius\Product\ProductHelper\ProductImageHelper;
use Lifestyle\Sylius\Product\Request\Validator\ProductPublishValidator;

/**
 * Class ProductPublishHandler
 *
 * @copyright  2019 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 * @package Lifestyle\Sylius\Product\Handler
 */
class ProductPublishHandler implements HandlerInterface
{
    use MessageResponsibilityTrait;
    use MessageHandlerTrait;

    /**
     * @var ProductPublishValidator
     */
    private $productValidator;

    /**
     * @var ProductImageHelper
     */
    private $productImageHelper;

    /**
     * ProductPublishHandler constructor.
     * @param ProductPublishValidator $productValidator
     * @param ProductImageHelper $productImageHelper
     */
    public function __construct(ProductPublishValidator $productValidator, ProductImageHelper $productImageHelper)
    {
        $this->productValidator = $productValidator;
        $this->productImageHelper = $productImageHelper;
    }

    /**
     * @param DataCollectorInterface $dataCollector
     * @return bool Should return true, if data has been processed
     * @throws \Doctrine\ORM\ORMException
     */
    public function handle(DataCollectorInterface $dataCollector): bool
    {
        if (!$this->isResponsible($dataCollector)) {
            return false;
        }

        $this->productValidator->validate($dataCollector);

        $processed = false;
        foreach ($this->messageHandler as $handler) {
            if ($handler->isResponsible($dataCollector)) {
                $handler->createOrUpdate($dataCollector);
                $processed = true;
            }
        }

        if ($processed) {
            $this->updateImages($dataCollector);
        }

        return $processed;
    }

    /**
     * @param DataCollectorInterface $dataCollector
     * @return bool
     */
    private function isResponsible(DataCollectorInterface $dataCollector): bool
    {
        return
            in_array($dataCollector->getItemValue('event'), $this->responsibleEvents) &&
            'variant' !== $dataCollector->getItemValue('type');
    }

    /**
     * @param DataCollectorInterface $dataCollector
     * @throws \Doctrine\ORM\ORMException
     */
    private function updateImages(DataCollectorInterface $dataCollector)
    {
        if (!$dataCollector->hasItem('imagesId')) {
            return;
        }

        $imageIds = $dataCollector->getItemValue('imagesId');
        $this->productImageHelper->updateProductImages(
            $dataCollector->getItemValue('id'),
            is_array($imageIds) ? $imageIds : [$imageIds]
        );
    }
}
