<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2019 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Lifestyle\Sylius\Product\ProductHelper;

use Sylius\Component\Product\Factory\ProductVariantFactory;

/**
 * Class ProductVariantExtensionDetector
 *
 * @copyright  2019 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 * @package Lifestyle\Sylius\Product\ProductHelper
 */
class ProductVariantExtensionDetector
{
    /**
     * @var ProductVariantFactory
     */
    private $productVariantFactory;

    /**
     * @var bool
     */
    private $isEnabled;

    /**
     * ProductVariantExtensionDetector constructor.
     * @param ProductVariantFactory $productVariantFactory
     */
    public function __construct(ProductVariantFactory $productVariantFactory)
    {
        $this->productVariantFactory = $productVariantFactory;
    }

    /**
     * @return bool
     */
    public function isEnabled(): bool
    {
        if (null === $this->isEnabled) {
            try {
                $reflectionClass = new \ReflectionClass($this->productVariantFactory->createNew());
            } catch (\ReflectionException $e) {
                return $this->isEnabled = false;
            }
            $this->isEnabled = $reflectionClass->hasMethod('setEnabled');
        }
        return $this->isEnabled;
    }
}
