# Life-Style Symfony Bundle To Handle Product Updates

This bundle receives messages from rabbitMQ and updates products in Sylius.

## Requirements

Sylius 1.3

## Installation

The repositories are private. You have to add them to your projects `composer.json`. Make sure you have access to the repositories.

```yaml
{
  "name": "your-project",

  ...

  "repositories": [
    {
      "type": "git",
      "url": "ssh://git@stash.life-style.de:7999/lcp/lifestylesyliusproductbundle.git"
    },
    {
      "type": "git",
      "url": "ssh://git@stash.life-style.de:7999/lcp/lifestylerabbitmqconsumerbundle.git"
    },
    {
        "type": "git",
        "url": "ssh://git@stash.life-style.de:7999/sb/sylius-rest-client.git"
    },
    {
      "type": "git",
      "url": "ssh://git@stash.life-style.de:7999/sb/data-collector-model.git"
    }
  ]
}
```

Install the package.

```bash
composer require lifestyle/sylius-product-bundle
```

## Configuration

You have to configure the [RabbitMqBundle](https://github.com/php-amqplib/RabbitMqBundle) as described in the [LifestyleRabbitMqConsumerBundle](https://stash.life-style.de/projects/LCP/repos/lifestylerabbitmqconsumerbundle) and the [LifestyleSyliusRestApiClientBundle](https://stash.life-style.de/projects/SB/repos/sylius-rest-client). Please read their documentation.

config/packages/lifestyle_sylius_product.yaml
```yaml
lifestyle_sylius_product:
    product_publish_events: [ 'product.publish' ]
    product_unpublish_events: [ 'product.unpublish' ]
    taxon_publish_events: [ 'taxon.publish' ]
    taxon_unpublish_events: [ 'taxon.unpublish' ]
    option_publish_events: [ 'option.publish' ]
    option_unpublish_events: [ 'option.unpublish' ]
```

