<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2019 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Lifestyle\Sylius\Product\Request\Validator;

use Lifestyle\DataCollector\DataCollectorInterface;
use Lifestyle\Sylius\Product\Request\Model\ProductUnpublish\Factory;
use Symfony\Component\Validator\Exception\ValidatorException;
use Symfony\Component\Validator\Validator\ValidatorInterface;

/**
 * Class ProductUnpublishValidator
 *
 * @copyright  2019 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 * @package Lifestyle\Sylius\Product\Request\Validator
 */
class ProductUnpublishValidator
{
    /**
     * @var Factory
     */
    private $modelFactory;

    /**
     * @var ValidatorInterface
     */
    private $validator;

    /**
     * ProductUnpublishValidator constructor.
     * @param Factory $modelFactory
     * @param ValidatorInterface $validator
     */
    public function __construct(Factory $modelFactory, ValidatorInterface $validator)
    {
        $this->modelFactory = $modelFactory;
        $this->validator = $validator;
    }

    /**
     * Do a minimal input validation
     *
     * @param DataCollectorInterface $dataCollector
     * @throws ValidatorException
     */
    public function validate(DataCollectorInterface $dataCollector): void
    {
        $product = $this->modelFactory->product();
        $product->setId($dataCollector->getItemValue('id'));
        $product->setType($dataCollector->getItemValue('type'));
        $product->setEnabled($dataCollector->getItemValue('enabled'));

        $validationGroup = $dataCollector->getItemValue('type') === 'variant' ? 'variant' : 'product';

        $violations = $this->validator->validate($product, null, $validationGroup);
        if (0 < count($violations)) {
            $errorMessages = [];
            foreach ($violations as $violation) {
                $errorMessages[] = (string)$violation;
            }
            throw new ValidatorException(sprintf(
                'Bad message format: %s',
                join(', ', $errorMessages)
            ));
        }
    }
}
