<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2019 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

declare(strict_types=1);

namespace Lifestyle\Sylius\Product\Form\EventSubscribers;

use Sylius\Bundle\ProductBundle\Form\Type\ProductOptionChoiceType;
use Symfony\Component\EventDispatcher\EventSubscriberInterface;
use Symfony\Component\Form\FormEvent;
use Symfony\Component\Form\FormEvents;

/**
 * Class ProductOptionFieldSubscriber
 *
 * This class enables the option-list-select in product-edit-form
 * even if at least one product variant does exist!
 *
 * @copyright  2019 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 * @package Lifestyle\Sylius\Product\Form\EventSubscribers
 */
final class ProductOptionFieldSubscriber implements EventSubscriberInterface
{
    /**
     * {@inheritdoc}
     */
    public static function getSubscribedEvents(): array
    {
        return [
            FormEvents::PRE_SET_DATA => [ 'preSetData', -1 ],
        ];
    }

    /**
     * {@inheritdoc}
     */
    public function preSetData(FormEvent $event): void
    {
        $form = $event->getForm();
        $form->remove('options');
        $form->add('options', ProductOptionChoiceType::class, [
            'required' => false,
            'disabled' => false, // We don't want option-list-changes to be disabled
            'multiple' => true,
            'label' => 'sylius.form.product.options',
        ]);
    }
}
