<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2019 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Lifestyle\Sylius\Product\Configuration;

/**
 * Class ProductConfiguration
 *
 * @copyright  2019 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 * @package Lifestyle\Sylius\Product\Configuration
 */
class ProductConfiguration
{
    /**
     * @var string
     */
    private $extraField1Type;

    /**
     * @var string
     */
    private $extraField2Type;

    /**
     * @var string
     */
    private $extraField3Type;

    /**
     * @var string
     */
    private $extraField4Type;

    /**
     * ProductConfiguration constructor.
     * @param string $extraField1Type
     * @param string $extraField2Type
     * @param string $extraField3Type
     * @param string $extraField4Type
     */
    public function __construct(
        string $extraField1Type,
        string $extraField2Type,
        string $extraField3Type,
        string $extraField4Type
    ) {
        $this->extraField1Type = $extraField1Type;
        $this->extraField2Type = $extraField2Type;
        $this->extraField3Type = $extraField3Type;
        $this->extraField4Type = $extraField4Type;
    }

    /**
     * @return string
     */
    public function getExtraField1Type(): string
    {
        return $this->extraField1Type;
    }

    /**
     * @return string
     */
    public function getExtraField2Type(): string
    {
        return $this->extraField2Type;
    }

    /**
     * @return string
     */
    public function getExtraField3Type(): string
    {
        return $this->extraField3Type;
    }

    /**
     * @return string
     */
    public function getExtraField4Type(): string
    {
        return $this->extraField4Type;
    }
}
