# Life-Style Symfony Bundle To Handle Product Updates

This bundle receives messages from rabbitMQ and updates products in Sylius.

## Requirements

Sylius 1.3

## Installation

The repositories are private. You have to add them to your projects `composer.json`. Make sure you have access to the repositories.

```yaml
{
  "name": "your-project",

  ...

  "repositories": [
    {
      "type": "git",
      "url": "ssh://git@stash.life-style.de:7999/lcp/lifestylesyliusproductbundle.git"
    },
    {
      "type": "git",
      "url": "ssh://git@stash.life-style.de:7999/lcp/lifestylerabbitmqconsumerbundle.git"
    },
    {
        "type": "git",
        "url": "ssh://git@stash.life-style.de:7999/sb/sylius-rest-client.git"
    },
    {
      "type": "git",
      "url": "ssh://git@stash.life-style.de:7999/sb/data-collector-model.git"
    }
  ]
}
```

Install the package.

```bash
composer require lifestyle/sylius-product-bundle
```

## Configuration

You have to configure the [RabbitMqBundle](https://github.com/php-amqplib/RabbitMqBundle) as described in the [LifestyleRabbitMqConsumerBundle](https://stash.life-style.de/projects/LCP/repos/lifestylerabbitmqconsumerbundle) and the [LifestyleSyliusRestApiClientBundle](https://stash.life-style.de/projects/SB/repos/sylius-rest-client). Please read their documentation.

_config/packages/lifestyle_sylius_product.yaml_
```yaml
lifestyle_sylius_product:
  assets:
    package_name: 'pimcore'
    json_manifest_path: '%kernel.project_dir%/public/assets/manifest.json'
    responsible_events:
      publish: [ 'asset.image.publish' ]
      unpublish: [ 'asset.image.unpublish' ]
  products:
    on_hand_property: 'onHand'
    fields:
      extra_field_1: 'text' # text or textarea
      extra_field_2: 'text'
      extra_field_3: 'textarea'
      extra_field_4: 'text'
    responsible_events:
      publish: [ 'product.publish' ]
      unpublish: [ 'product.unpublish' ]
  taxon:
    responsible_events:
      publish: [ 'taxon.publish' ]
      unpublish: [ 'taxon.unpublish' ]
```

Update the asset management in your project. The configuration of the asset-package, which has to be managed by this plugin, has to be updated:

```yaml
framework:
    assets:
        packages:
            pimcore:
                version_strategy: 'Lifestyle\Sylius\Product\Asset\VersionStrategy\JsonManifestVersionStrategy'
```
