<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2019 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Lifestyle\Sylius\Product\Request\Model\ProductUnpublish;

use Symfony\Component\Validator\Constraints as Assert;

/**
 * Class Product
 *
 * @copyright  2019 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 * @package Lifestyle\Sylius\Product\RequestModel\ProductUnpublish
 */
class Product
{
    /**
     * @Assert\NotNull(groups={"product", "variant"})
     * @var string|null
     */
    private $id;

    /**
     * @Assert\NotNull(groups={"product", "variant"})
     * @Assert\EqualTo(value="object", groups={"product"})
     * @Assert\EqualTo(value="variant", groups={"variant"})
     * @var string|null
     */
    private $type;

    /**
     * @Assert\NotNull(groups={"product"})
     * @Assert\IsFalse(groups={"product"})
     * @var bool|null
     */
    private $enabled;

    /**
     * @param string $id
     */
    public function setId(?string $id): void
    {
        $this->id = $id;
    }

    /**
     * @param string|null $type
     */
    public function setType(?string $type): void
    {
        $this->type = $type;
    }

    /**
     * @param bool|null $enabled
     */
    public function setEnabled(?bool $enabled): void
    {
        $this->enabled = $enabled;
    }
}
