<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2019 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Lifestyle\Sylius\Product\Form\Extension;

use Lifestyle\Sylius\Product\Configuration\ProductConfiguration;
use Symfony\Component\Form\AbstractTypeExtension;
use Sylius\Bundle\ProductBundle\Form\Type\ProductTranslationType;
use Symfony\Component\Form\Extension\Core\Type\TextareaType;
use Symfony\Component\Form\Extension\Core\Type\TextType;
use Symfony\Component\Form\FormBuilderInterface;

/**
 * Class ProductTranslationTypeExtension
 *
 * @copyright  2019 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 * @package Lifestyle\Sylius\Product\Form\Extension
 * @method iterable getExtendedTypes()
 */
class ProductTranslationTypeExtension extends AbstractTypeExtension
{
    /**
     * @var ProductConfiguration
     */
    private $productConfiguration;

    /**
     * ProductTranslationTypeExtension constructor.
     * @param ProductConfiguration $productConfiguration
     */
    public function __construct(ProductConfiguration $productConfiguration)
    {
        $this->productConfiguration = $productConfiguration;
    }

    /**
     * @param FormBuilderInterface $builder
     * @param array $options
     */
    public function buildForm(FormBuilderInterface $builder, array $options): void
    {
        $builder->add('extraField1', $this->getFieldType($this->productConfiguration->getExtraField1Type()), [
            'required' => false,
            'label' => 'lifestyle_sylius_product_plugin.ui.product_translation.extra_field_1',
        ]);
        $builder->add('extraField2', $this->getFieldType($this->productConfiguration->getExtraField2Type()), [
            'required' => false,
            'label' => 'lifestyle_sylius_product_plugin.ui.product_translation.extra_field_2',
        ]);
        $builder->add('extraField3', $this->getFieldType($this->productConfiguration->getExtraField3Type()), [
            'required' => false,
            'label' => 'lifestyle_sylius_product_plugin.ui.product_translation.extra_field_3',
        ]);
        $builder->add('extraField4', $this->getFieldType($this->productConfiguration->getExtraField4Type()), [
            'required' => false,
            'label' => 'lifestyle_sylius_product_plugin.ui.product_translation.extra_field_4',
        ]);
    }

    /**
     * @param string $fieldType
     * @return string
     */
    private function getFieldType(string $fieldType): string
    {
        return $fieldType === 'text' ? TextType::class : TextareaType::class;
    }

    /**
     * @return string
     */
    public function getExtendedType(): string
    {
        return ProductTranslationType::class;
    }
}
