<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2019 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

declare(strict_types=1);

namespace Lifestyle\Sylius\Product\Form\Extension;

use Lifestyle\Sylius\Product\Form\EventSubscribers\ProductOptionFieldSubscriber;
use Sylius\Bundle\ProductBundle\Form\Type\ProductType;
use Symfony\Component\Form\AbstractTypeExtension;
use Symfony\Component\Form\Extension\Core\Type\TextType;
use Symfony\Component\Form\FormBuilderInterface;

/**
 * Class ProductTypeExtension
 *
 * @copyright  2019 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 * @package Lifestyle\Sylius\Product\Form\Extension
 * @method iterable getExtendedTypes()
 */
class ProductTypeExtension extends AbstractTypeExtension
{
    /**
     * @inheritDoc
     */
    public function buildForm(FormBuilderInterface $builder, array $options)
    {
        // Add event subscriber to enable option-list-select in product-edit-form
        $builder->addEventSubscriber(new ProductOptionFieldSubscriber());
        $builder->add('concept', TextType::class, [
            'label' => 'lifestyle_sylius_product_plugin.ui.product.concept',
            'required' => false
        ]);
    }

    /**
     * @inheritDoc
     */
    public function getExtendedType(): string
    {
        return ProductType::class;
    }
}
