<?php declare(strict_types=1);

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2019 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Lifestyle\Sylius\Product\Entity;

use Doctrine\Common\Collections\ArrayCollection;
use Doctrine\Common\Collections\Collection;
use Lifestyle\Sylius\Asset\Entity\AssetStorage;
use Lifestyle\Sylius\Asset\Entity\AssetStorageInterface;
use Sylius\Component\Core\Model\Product as BaseProduct;

/**
 * Class Product
 * @package Lifestyle\Sylius\Product\Entity
 */
class Product extends BaseProduct implements ProductInterface, ReviewableProductInterface
{
    /**
     * @var AssetStorage[]|ArrayCollection|null
     */
    protected $assets;

    /**
     * @var Tag[]|ArrayCollection|null
     */
    protected $tags;

    /**
     * Product constructor.
     */
    public function __construct()
    {
        parent::__construct();
        $this->assets = new ArrayCollection();
        $this->tags = new ArrayCollection();
    }

    /**
     * @return Collection
     */
    public function getAssets(): Collection
    {
        return $this->assets;
    }

    /**
     * @param AssetStorageInterface $assetStorage
     */
    public function addAsset(AssetStorageInterface $assetStorage): void
    {
        if (!$this->hasAsset($assetStorage)) {
            $this->assets->add($assetStorage);
        }
    }

    /**
     * @param AssetStorageInterface $assetStorage
     */
    public function removeAsset(AssetStorageInterface $assetStorage): void
    {
        if ($this->hasAsset($assetStorage)) {
            $this->assets->removeElement($assetStorage);
        }
    }

    /**
     * @param AssetStorageInterface $assetStorage
     * @return bool
     */
    public function hasAsset(AssetStorageInterface $assetStorage): bool
    {
        return $this->assets->contains($assetStorage);
    }

    /**
     * @return bool
     */
    public function hasAssets()
    {
        return $this->assets->count() !== 0 ? true : false;
    }

    /**
     * @return Collection
     */
    public function getTags(): Collection
    {
        return $this->tags;
    }

    /**
     * @param TagInterface $tag
     */
    public function addTag(TagInterface $tag): void
    {
        if (!$this->hasTag($tag)) {
            $this->tags->add($tag);
        }
    }

    /**
     * @param TagInterface $tag
     */
    public function removeTag(TagInterface $tag): void
    {
        if ($this->hasTag($tag)) {
            $this->tags->removeElement($tag);
        }
    }

    /**
     * @param TagInterface $tag
     * @return bool
     */
    public function hasTag(TagInterface $tag): bool
    {
        return $this->tags->contains($tag);
    }

    /**
     * @return bool
     */
    public function hasTags()
    {
        return $this->tags->count() !== 0 ? true : false;
    }
}
