<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2019 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Lifestyle\Sylius\Product\Entity;

use Sylius\Component\Core\Model\ProductTranslation as BaseProductTranslation;

/**
 * Class Product
 *
 * @copyright  2019 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 * @package Lifestyle\Sylius\Product\Entity
 */
class ProductTranslation extends BaseProductTranslation
{
    /**
     * @var string|null
     */
    private $extraField1;

    /**
     * @var string|null
     */
    private $extraField2;

    /**
     * @var string|null
     */
    private $extraField3;

    /**
     * @var string|null
     */
    private $extraField4;

    /**
     * @return string|null
     */
    public function getExtraField1(): ?string
    {
        return $this->extraField1;
    }

    /**
     * @param string|null $extraField1
     */
    public function setExtraField1(?string $extraField1): void
    {
        $this->extraField1 = $extraField1;
    }

    /**
     * @return string|null
     */
    public function getExtraField2(): ?string
    {
        return $this->extraField2;
    }

    /**
     * @param string|null $extraField2
     */
    public function setExtraField2(?string $extraField2): void
    {
        $this->extraField2 = $extraField2;
    }

    /**
     * @return string|null
     */
    public function getExtraField3(): ?string
    {
        return $this->extraField3;
    }

    /**
     * @param string|null $extraField3
     */
    public function setExtraField3(?string $extraField3): void
    {
        $this->extraField3 = $extraField3;
    }

    /**
     * @return string|null
     */
    public function getExtraField4(): ?string
    {
        return $this->extraField4;
    }

    /**
     * @param string|null $extraField4
     */
    public function setExtraField4(?string $extraField4): void
    {
        $this->extraField4 = $extraField4;
    }
}
