<?php
/**
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @author    Franz Weisflug
 * @copyright 2019 Lifestyle Webconsulting GmbH
 * @link      www.life-style.de
 */

namespace Lifestyle\Sylius\Product\ProductHelper;

use Doctrine\ORM\EntityRepository;
use Lifestyle\Sylius\Product\Exception\ObjectNotFoundException;
use Lifestyle\Sylius\Product\Entity\Product;
use Sylius\Component\Core\Model\ProductVariant;

trait ProductEntityTrait
{
    /**
     * @param EntityRepository $productRepository
     * @param string           $productCode
     *
     * @return Product
     */
    private function getProduct(EntityRepository $productRepository, string $productCode): Product
    {
        $product = $productRepository->findOneBy(['code' => $productCode]);
        if (!$product instanceof Product) {
            throw new ObjectNotFoundException(sprintf(
                'Cannot proceed image-update! Product (code: %s) not found.',
                $productCode
            ));
        }

        return $product;
    }

    /**
     * @param string  $productVariantCode
     * @param Product $product
     *
     * @return ProductVariant
     */
    private function getProductVariant(string $productVariantCode, Product $product): ProductVariant
    {
        $productVariant = $product->getVariants()
            ->filter(function (ProductVariant $productVariant) use ($productVariantCode) {
                return $productVariant->getCode() === $productVariantCode;
            })
            ->first();
        if (!$productVariant instanceof ProductVariant) {
            throw new ObjectNotFoundException(sprintf(
                'Cannot proceed image-update! ProductVariant (code: %s) not found for product (code: %s).',
                $productVariantCode,
                $product->getCode()
            ));
        }
        return $productVariant;
    }
}