<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2019 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Lifestyle\Sylius\Product\Request\Model\ProductPublish;

use Symfony\Component\Validator\Constraints as Assert;

/**
 * Class Product
 *
 * @copyright  2019 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 * @package Lifestyle\Sylius\Product\RequestModel\ProductPublish
 */
class Product
{
    /**
     * @Assert\NotNull(groups={"product", "variant"})
     * @var string
     */
    private $id;

    /**
     * @Assert\NotNull(groups={"variant"})
     * @var string
     */
    private $parentId;

    /**
     * @Assert\NotNull(groups={"product", "variant"})
     * @Assert\Choice(choices={"object", "variant"}, groups={"product", "variant"})
     * @var string|null
     */
    private $type;

    /**
     * @Assert\NotNull(groups={"product"})
     * @Assert\Count(min="1", groups={"product"})
     * @var array
     */
    private $channels;

    /**
     * @Assert\NotNull(groups={"variant"})
     * @Assert\Count(min="1", groups={"variant"})
     * @var array
     */
    private $prices;

    /**
     * @Assert\Valid(groups={"product", "variant"})
     * @var LocalizedFields[]
     */
    private $localizedFields;

    /**
     * @Assert\Valid(groups={"product", "variant"})
     * @var Option[]
     */
    private $options;

    /**
     * @Assert\Valid(groups={"product", "variant"})
     * @var Attribute[]
     */
    private $attributes;

    /**
     * @param string $id
     */
    public function setId(?string $id): void
    {
        $this->id = $id;
    }

    /**
     * @param string $parentId
     */
    public function setParentId(?string $parentId): void
    {
        $this->parentId = $parentId;
    }

    /**
     * @param string|null $type
     */
    public function setType(?string $type): void
    {
        $this->type = $type;
    }

    /**
     * @param LocalizedFields $localizedFields
     */
    public function addLocalizedFields(LocalizedFields $localizedFields): void
    {
        $this->localizedFields[] = $localizedFields;
    }

    /**
     * @param array $channels
     */
    public function setChannels(?array $channels): void
    {
        $this->channels = $channels;
    }

    /**
     * @param array $prices
     */
    public function setPrices(?array $prices): void
    {
        $this->prices = $prices;
    }

    /**
     * @param Option $option
     */
    public function addOption(Option $option)
    {
        $this->options[] = $option;
    }

    /**
     * @param Attribute $attribute
     */
    public function addAttribute(Attribute $attribute)
    {
        $this->attributes[] = $attribute;
    }
}
