# Life-Style Symfony Bundle To Improve Product Variant Updates

This bundle extends the product variant entity with additional features, to disable product variants inside a product without disabling the whole product.

## Requirements

Sylius 1.3

## Installation

The repository is private. You have to add it to your projects `composer.json`. Make sure you have access to the repository.

```yaml
{
  "name": "your-project",

  ...

  "repositories": [
    {
      "type": "git",
      "url": "ssh://git@stash.life-style.de:7999/lcp/lifestylesyliusproductvariantplugin.git"
    }
  ]
}
```

Install the package.

```bash
composer require lifestyle/sylius-product-variant-plugin
```

## Update database

```bash
cp vendor/lifestyle/sylius-product-variant-plugin/src/Migrations/Version*.php src/Migrations/.
php bin/console doctrine:migrations:migrate
```

## Enable bundle

_config/bundles.php:_
```php
<?php

return [
    ...
    Lifestyle\Sylius\ProductVariant\LifestyleSyliusProductVariantPlugin::class => ['all' => true],
];
```

## Configuration

_config/packages/lifestyle.yaml:_
```yaml
imports:
    - { resource: "@LifestyleSyliusProductVariantPlugin/Resources/config/config.yml" }
```
