<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2019 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Lifestyle\Sylius\ProductVariant\Twig\Extension;

use Lifestyle\Sylius\ProductVariant\Entity\ProductVariant;
use Lifestyle\Sylius\ProductVariant\Service\ShippingCalculatorInterface;

/**
 * Class ProductVariantExtension
 *
 * @copyright  2019 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 * @package Lifestyle\Sylius\ProductVariant\Twig\Extension
 */
class ProductVariantExtension extends \Twig_Extension
{
    /**
     * @var ShippingCalculatorInterface
     */
    private $shippingCalculator;

    /**
     * ProductVariantExtension constructor.
     * @param ShippingCalculatorInterface $shippingCalculator
     */
    public function __construct(ShippingCalculatorInterface $shippingCalculator)
    {
        $this->shippingCalculator = $shippingCalculator;
    }

    /**
     * {@inheritdoc}
     */
    public function getFunctions(): array
    {
        return [
            new \Twig_Function('lifestyle_sylius_product_variants_enabled', [$this, 'productVariantsEnabled']),
            new \Twig_Function('lifestyle_sylius_product_variants_has_shipping_costs', [$this->shippingCalculator, 'hasShippingCosts']),
        ];
    }

    /**
     * @param $productVariants
     * @return bool
     */
    public function productVariantsEnabled($productVariants): bool
    {
        foreach ($productVariants as $productVariant) {
            if ($this->productVariantIsEnabled($productVariant)) {
                return true;
            }
        }
        return false;
    }

    /**
     * @param ProductVariant $productVariant
     * @return bool
     */
    private function productVariantIsEnabled(ProductVariant $productVariant): bool
    {
        return $productVariant->isEnabled();
    }
}
