<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2019 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Lifestyle\Sylius\ProductVariant\Entity;

use Sylius\Component\Core\Model\ProductVariant as BaseProductVariant;
use Sylius\Component\Resource\Model\ToggleableTrait;

/**
 * Class ProductVariant
 *
 * @copyright  2019 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 * @package Lifestyle\Sylius\ProductVariant\Entity
 */
class ProductVariant extends BaseProductVariant implements ProductVariantInterface
{
    // Brings in a new function to disable product-variants
    use ToggleableTrait;

    /**
     * @var string|null
     */
    private $sku;

    /**
     * @return string|null
     */
    public function getSku(): ?string
    {
        return $this->sku;
    }

    /**
     * @param string|null $sku
     */
    public function setSku(?string $sku): void
    {
        $this->sku = $sku;
    }
}
