<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2019 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Lifestyle\Sylius\ProductVariant\Entity;

use Sylius\Component\Core\Model\ProductVariantInterface as BaseProductVariantInterface;
use Sylius\Component\Resource\Model\ToggleableInterface;

/**
 * Interface ProductVariantInterface
 *
 * @copyright  2019 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 * @package Lifestyle\Sylius\ProductVariant\Entity
 */
interface ProductVariantInterface extends BaseProductVariantInterface, ToggleableInterface
{
    /**
     * @return string|null
     */
    public function getSku(): ?string;

    /**
     * @param string|null $sku
     */
    public function setSku(?string $sku): void;
}
