<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2019 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Lifestyle\Sylius\ProductVariant\Entity;

use Doctrine\Common\Collections\ArrayCollection;
use Lifestyle\Sylius\Asset\Entity\AssetStorage;
use Lifestyle\Sylius\Asset\Entity\AssetStorageInterface;
use Sylius\Component\Core\Model\ProductVariant as BaseProductVariant;
use Sylius\Component\Resource\Model\ToggleableTrait;
use Doctrine\Common\Collections\Collection;

/**
 * Class ProductVariant
 *
 * @copyright  2019 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 * @package    Lifestyle\Sylius\ProductVariant\Entity
 */
class ProductVariant extends BaseProductVariant implements ProductVariantInterface
{
    // Brings in a new function to disable product-variants
    use ToggleableTrait;

    /**
     * @var string|null
     */
    private $sku;

    /**
     * @var AssetStorage[]|ArrayCollection|null
     */
    protected $assets;

    /**
     * ProductVariant constructor.
     */
    public function __construct()
    {
        parent::__construct();
        $this->assets = new ArrayCollection();
    }

    /**
     * @return Collection
     */
    public function getAssets(): Collection
    {
        return $this->assets;
    }

    /**
     * @param AssetStorageInterface $assetStorage
     */
    public function addAsset(AssetStorageInterface $assetStorage): void
    {
        if (!$this->hasAsset($assetStorage)) {
            $this->assets->add($assetStorage);
        }
    }

    /**
     * @param AssetStorageInterface $assetStorage
     */
    public function removeAsset(AssetStorageInterface $assetStorage): void
    {
        if ($this->hasAsset($assetStorage)) {
            $this->assets->removeElement($assetStorage);
        }
    }

    /**
     * @param AssetStorageInterface $assetStorage
     * @return bool
     */
    public function hasAsset(AssetStorageInterface $assetStorage): bool
    {
        return $this->assets->contains($assetStorage);
    }

    /**
     * @return bool
     */
    public function hasAssets()
    {
        return $this->assets->count() !== 0 ? true : false;
    }

    /**
     * @return string|null
     */
    public function getSku(): ?string
    {
        return $this->sku;
    }

    /**
     * @param string|null $sku
     */
    public function setSku(?string $sku): void
    {
        $this->sku = $sku;
    }
}
