<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2019 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

declare(strict_types=1);

namespace Lifestyle\Sylius\ProductVariant\Resolver;

use LifeStyle\Sylius\DataModelPlugin\Entity\ProductVariant as ExtendedProductVariant;
use Sylius\Component\Product\Model\ProductInterface;
use Sylius\Component\Product\Model\ProductVariantInterface;
use Sylius\Component\Product\Resolver\ProductVariantResolverInterface;

/**
 * Class ProductVariantResolver
 *
 * @copyright  2019 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 * @package Lifestyle\Sylius\ProductVariant\Resolver
 */
final class ProductVariantResolver implements ProductVariantResolverInterface
{
    /**
     * @param ProductInterface $subject
     * @return ProductVariantInterface|null
     */
    public function getVariant(ProductInterface $subject): ?ProductVariantInterface
    {
        if (!$subject->getVariants()->isEmpty()) {
            $productVariant = $subject->getVariants()->first();
            if (!$productVariant instanceof ExtendedProductVariant) {
                return $productVariant;
            }

            foreach ($subject->getVariants() as $productVariant) {
                if ($productVariant->isEnabled()) {
                    return $productVariant;
                }
            }
        }

        return null;
    }
}
