<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2019 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Lifestyle\Sylius\ProductVariant\Model;

/**
 * Class AssetModel
 * @package Lifestyle\Sylius\ProductVariant\Model
 */
class AssetModel
{
    /**
     * @var string
     */
    private $resourceId;

    /**
     * @var string
     */
    private $title;

    /**
     * @var string
     */
    private $locale;

    /**
     * AssetModel constructor.
     * @param string $resourceId
     * @param string $title
     * @param string $locale
     */
    public function __construct(string $resourceId, string $title, string $locale)
    {
        $this->resourceId = $resourceId;
        $this->title = $title;
        $this->locale = $locale;
    }

    /**
     * @return string
     */
    public function getResourceId(): string
    {
        return $this->resourceId;
    }

    /**
     * @return string
     */
    public function getTitle(): string
    {
        return $this->title;
    }

    /**
     * @return string
     */
    public function getLocale(): string
    {
        return $this->locale;
    }
}
