# Life-Style Symfony Bundle To Improve Product Variant Updates

This bundle extends the product variant entity with additional features, to disable product variants inside a product without disabling the whole product.

## Requirements

Sylius 1.3

## Installation

The repository is private. You have to add it to your projects `composer.json`. Make sure you have access to the repository.

```yaml
{
  "name": "your-project",

  ...

  "repositories": [
    {
      "type": "git",
      "url": "ssh://git@stash.life-style.de:7999/lcp/lifestylesyliusproductvariantplugin.git"
    }
  ]
}
```

Install the package.

```bash
composer require lifestyle/sylius-product-variant-plugin
```

## Update database

```bash
cp vendor/lifestyle/sylius-product-variant-plugin/src/Migrations/Version*.php src/Migrations/.
php bin/console doctrine:migrations:migrate
```

## Enable bundle

_config/bundles.php:_
```php
<?php

return [
    ...
    Lifestyle\Sylius\ProductVariant\LifestyleSyliusProductVariantPlugin::class => ['all' => true],
];
```

## Configuration

To load admin-templates the twig configuration in your project has to be updated like:

_config/packages/twig.yaml:_
```yaml
twig:
    paths:
        '%kernel.project_dir%/templates': ~
        '%kernel.project_dir%/themes': ~
        '%kernel.project_dir%/vendor/lifestyle/sylius-product-variant-plugin/src/Resources/views/Admin': 'SyliusAdmin'
    debug: '%kernel.debug%'
    strict_variables: '%kernel.debug%'
```
