# Life-Style Sylius Registration Extension Plugin

##Installation

The repositories are private. You have to add them to your projects `composer.json`. Make sure you have access to the repositories.

```yaml
{
  "name": "your-project",

  ...

  "repositories": [
    ...
    {
        "type": "git",
        "url": "ssh://git@stash.life-style.de:7999/lcp/lifestylesyliusregistrationextensionplugin.git"
    }
  ]
}
```

Install the package.

```bash
composer require lifestyle/sylius-registration-extension-plugin
```

### Add to bundles

If you Sylius is based on Symfony 3.4 or 4.x this is done by `composer`.

_config/bundles.php:_
```php
<?php

return [
    ...
    LifeStyle\Sylius\RegistrationExtensionPlugin\LifeStyleSyliusRegistrationExtensionPlugin::class => ['all' => true],
];
```

### Add route

_config/routes/lifestyle_sylius_pricing_plugin.yaml:_

```yaml
import:
 - { resource: "@LifeStyleSyliusRegistrationExtensionPlugin/Resources/config/config.yml" }
```

### Update database

```bash
cp vendor/lifestyle/sylius-registration-extension-plugin/src/Migrations/Version20190225055708.php src/Migrations/.
php bin/console doctrine:migrations:migrate
```

### Update templates (projects without theme)

```bash
cp -r vendor/lifestyle/sylius-registration-extension-plugin/src/Resources/views/templates/* templates/.
php bin/console doctrine:migrations:migrate
```

### for project with themes

```
@SyliusShopBundle/Account/profileUpdate.hml.twig
@SyliusShopBundle/Register/_form.hml.twig

{% if life_style_registration_extension is defined AND life_style_registration_extension == true %}
    <div class="two fields">
        {{ form_row(form.companyName) }}
        {{ form_row(form.taxId) }}
    </div>
{% endif %}
```

good luck and have fun!
