<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright   2019 Lifestyle Webconsulting GmbH
 * @link        http://www.life-style.de
 */

declare(strict_types=1);

namespace LifeStyle\Sylius\RegistrationExtensionPlugin\Form\Extension;

use Sylius\Bundle\CustomerBundle\Form\Type\CustomerProfileType;
use Symfony\Component\Form\AbstractTypeExtension;
use Symfony\Component\Form\Extension\Core\Type\TextType;
use Sylius\Bundle\AddressingBundle\Form\Type\AddressType;
use Symfony\Component\Form\FormBuilderInterface;

/**
 * Class CustomerFormTypeExtension
 */
class CustomerFormTypeExtension extends AbstractTypeExtension
{
    /**
     * @param FormBuilderInterface $builder
     * @param array $options
     */
    public function buildForm(FormBuilderInterface $builder, array $options): void
    {
        // Adding new fields works just like in the parent form type.
        $builder->add('companyName', TextType::class, [
            'required' => true,
            'label' => 'life_style.ui.company_name',
        ]);

        $builder->add('taxId', TextType::class, [
            'required' => true,
            'label' => 'life_style.ui.tax_id',
        ]);

        $builder->add('customerNumber', TextType::class, [
            'required' => false,
            'label' => 'life_style.ui.customer_number'
        ]);

    }

    /**
     * @return array|iterable
     */
    public function getExtendedTypes()
    {
        return [CustomerProfileType::class];
    }
}
