<?php

/**
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2017 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Lifestyle\Sylius\RestApiClientBundle\Services\ProductVariant\Version1\Get\Model\Response;

use JMS\Serializer\Annotation as Serializer;

/**
 * Class ProductVariant
 * @package Lifestyle\Sylius\RestApiClientBundle\Services\ProductVariant\Version1\Get\Model\Response
 */
class ProductVariant
{
    /**
     * @Serializer\Type("int")
     * @var int
     */
    private $id;

    /**
     * @Serializer\Type("string")
     * @var string
     */
    private $code;

    /**
     * @Serializer\Type("int")
     * @var int
     */
    private $position;

    /**
     * @Serializer\Type("int")
     * @var int
     */
    private $version;

    /**
     * @Serializer\SerializedName("onHold")
     * @Serializer\Type("int")
     * @var int
     */
    private $onHold;

    /**
     * @Serializer\SerializedName("onHand")
     * @Serializer\Type("int")
     * @var int
     */
    private $onHand;

    /**
     * @Serializer\Type("bool")
     * @var bool
     */
    private $tracked;

    /**
     * ProductVariant constructor.
     * @param int $id
     * @param string $code
     * @param int $position
     * @param int $version
     * @param int $onHold
     * @param int $onHand
     * @param bool $tracked
     */
    public function __construct($id, $code, $position, $version, $onHold, $onHand, $tracked)
    {
        $this->id = $id;
        $this->code = $code;
        $this->position = $position;
        $this->version = $version;
        $this->onHold = $onHold;
        $this->onHand = $onHand;
        $this->tracked = $tracked;
    }

    /**
     * @return int
     */
    public function getId()
    {
        return $this->id;
    }

    /**
     * @return string
     */
    public function getCode()
    {
        return $this->code;
    }

    /**
     * @return int
     */
    public function getPosition()
    {
        return $this->position;
    }

    /**
     * @return int
     */
    public function getVersion()
    {
        return $this->version;
    }

    /**
     * @return int
     */
    public function getOnHold()
    {
        return $this->onHold;
    }

    /**
     * @return int
     */
    public function getOnHand()
    {
        return $this->onHand;
    }

    /**
     * @return bool
     */
    public function isTracked()
    {
        return $this->tracked;
    }
}
