<?php

/**
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2018 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Tests\Lifestyle\Sylius\RestApiClientBundle\Services\Product\Version1\Get;

use Lifestyle\Sylius\RestApiClientBundle\Services\Product\Version1\Get\Model\Response\ProductVariantData;
use PHPUnit\Framework\TestCase;

/**
 * Class ModelTest
 * @package Tests\Lifestyle\Sylius\RestApiClientBundle\Services\Product\Version1\Get
 */
class ModelTest extends TestCase
{
    public function testProductVariantData()
    {
        $productVariantData = new ProductVariantData();
        $productVariantData->setLimit(101);
        $productVariantData->setPage(102);
        $productVariantData->setPages(103);
        $productVariantData->setTotal(104);
        $this->assertEquals(101, $productVariantData->getLimit());
        $this->assertEquals(102, $productVariantData->getPage());
        $this->assertEquals(103, $productVariantData->getPages());
        $this->assertEquals(104, $productVariantData->getTotal());

    }
}
